<?php

/* -----------------------------------------------------------------
 * 	$Id: fruugo.php 717 2013-11-05 15:38:31Z akausch $
 * 	Copyright (c) 2011-2021 commerce:SEO by Webdesign Erfurt
 * 	http://www.commerce-seo.de
 * ------------------------------------------------------------------
 * 	based on:
 * 	(c) 2000-2001 The Exchange Project  (earlier name of osCommerce)
 * 	(c) 2002-2003 osCommerce - www.oscommerce.com
 * 	(c) 2003     nextcommerce - www.nextcommerce.org
 * 	(c) 2005     xt:Commerce - www.xt-commerce.com
 * 	(c) 2013     Gambio GmbH - www.gambio.de
 * 	Released under the GNU General Public License
 * --------------------------------------------------------------- */

class Fruugo {

    var $v_partnerlink;
    var $v_export_type;
    var $v_module_name;
    var $v_module_homepage;
    var $v_module_format;
    var $v_module_export_filename;
    var $v_filename;
    var $v_keyname;
    var $v_linkname;
    var $v_delimiter;
    var $v_enclosure;
    var $v_field_filename;
    var $v_field_customers_groups;
    var $v_field_currency;
    var $v_field_shipping_costs;
    var $v_field_shipping_costs_free;
    var $v_field_attributes;
    var $v_field_campaign;
    var $v_field_export;

    function Fruugo() {
        $this->formSettings();
        $shipping_countries = array();
        foreach ($this->_get_active_countries() as $country) {
            $shipping_countries[] = $country['countries_iso_code_2'];
        }
        $this->shipping_countries = implode(' ', $shipping_countries);
    }

    function formSettings() {
        $this->v_partnerlink = '';
        $this->v_export_type = 'selling';
        $this->v_module_name = 'Froogogermany.de';
        $this->v_module_homepage = 'www.fruugogermany.de';
        $this->v_module_format = 'csv';
        $this->v_module_export_filename = 'fruugo.csv';
        $this->v_filename = basename(__FILE__);
        $this->v_keyname = 'FRUUGO';
        $this->v_linkname = 'fruugo';
        $this->v_delimiter = ",";
        $this->v_enclosure = '"';
        $this->v_field_filename = true;
        $this->v_field_customers_groups = true;
        $this->v_field_currency = true;
        $this->v_field_shipping_costs = false;
        $this->v_field_shipping_costs_free = false;
        $this->v_field_attributes = true;
        $this->v_field_campaign = false;
        $this->v_field_export = true;
    }

    function formAddOn() {
        $addon = '';
        return $addon;
    }

    function formatResults($p_products_array) {
        if (isset($p_products_array['products_id_product'])) { // has attribute
            $p_products_array['fruugo_sku_id'] = $p_products_array['products_attributes_id'];
            $p_products_array['fruugo_stockstatus'] = $this->_determineStockStatus($p_products_array['products_id_product']);
        } else {
            $p_products_array['fruugo_sku_id'] = $p_products_array['products_id'];
            $p_products_array['fruugo_stockstatus'] = $this->_determineStockStatus($p_products_array['products_id']);
        }
        if (isset($p_products_array['products_id_copy'])) { // has attribute, Google Shopping Export installed
            $p_products_array['fruugo_sku_id'] = $p_products_array['products_attributes_id'];
            $p_products_array['fruugo_stockstatus'] = $this->_determineStockStatus($p_products_array['products_id_copy']);
        } else {
            $p_products_array['fruugo_sku_id'] = $p_products_array['products_id'];
            $p_products_array['fruugo_stockstatus'] = $this->_determineStockStatus($p_products_array['products_id']);
        }

        $p_products_array['products_name'] = utf8_encode($p_products_array['products_name']);
        if (isset($p_products_array['retail_price'])) {
            $p_products_array['fruugo_normalprice'] = number_format($p_products_array['retail_price'], 2, '.', '');
            $p_products_array['fruugo_discountprice'] = $p_products_array['products_price'];
        } else {
            $p_products_array['fruugo_normalprice'] = $p_products_array['products_price'];
            $p_products_array['fruugo_discountprice'] = ''; // $p_products_array['products_price'];
        }
        $p_products_array['fruugo_countries'] = $this->shipping_countries;
        $p_products_array['fruugo_description'] = utf8_encode(strip_tags($p_products_array['products_description']));
        $p_products_array['products_categories'] = utf8_encode($p_products_array['products_categories']);
        $p_products_array['packageweight'] = number_format($p_products_array['products_weight'] * 1000, 0, '', '');

        return $p_products_array;
    }

    function exportScheme() {
        $t_csv_fields_array = array();

        // mandatory columns
        $t_csv_fields_array['products_id'] = 'ProductId';
        $t_csv_fields_array['fruugo_sku_id'] = 'SkuId';
        $t_csv_fields_array['products_image_1'] = 'Imageurl1';
        $t_csv_fields_array['fruugo_stockstatus'] = 'StockStatus';
        $t_csv_fields_array['packageweight'] = 'PackageWeight';
        $t_csv_fields_array['products_name'] = 'Title';
        $t_csv_fields_array['fruugo_normalprice'] = 'NormalPriceWithVAT';

        // optional columns
        $t_csv_fields_array['fruugo_discountprice'] = 'DiscountPriceWithVAT';
        $t_csv_fields_array['products_tax'] = 'VATRate';
        $t_csv_fields_array['products_currency'] = 'Currency';
        //$t_csv_fields_array['fruugo_countries'] = 'Country';
        $t_csv_fields_array['products_ean'] = 'EAN';
        if (isset($t_csv_fields_array['products_isbn'])) {
            $t_csv_fields_array['products_isbn'] = 'ISBN';
        }
        $t_csv_fields_array['manufacturers_name'] = 'Manufacturer';
        $t_csv_fields_array['products_categories'] = 'Category';
        $t_csv_fields_array['fruugo_description'] = 'Description';

        return($t_csv_fields_array);
    }

    /**
     * determine stock status, assuming shipping_time id 1 means INSTOCK
     */
    function _determineStockStatus($products_id) {
        $statusq = xtc_db_query("SELECT products_shippingtime FROM products WHERE products_id = " . (int) $products_id);
        while ($row = xtc_db_fetch_array($statusq)) {
            if ($row['products_shippingtime'] == 1) {
                return 'INSTOCK';
            }
        }
        return 'OUTOFSTOCK';
    }

    /**
     * get active countries
     * @return array rows from countries table
     */
    function _get_active_countries() {
        $query = "SELECT * FROM " . TABLE_COUNTRIES . " WHERE status = 1";
        $result = xtc_db_query($query);
        $countries = array();
        while ($row = xtc_db_fetch_array($result)) {
            $countries[] = $row;
        }
        return $countries;
    }

}
